


export class RentalContractsWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.newContract_Click" class="fa fa-plus"></a>
			</div>
			
			<h1>{{ _('Overview contracts') }}</h1>
		</div>
		
		<div>
			<ez-radio name="t" value="active" label="">
				<option value="all">{{_('All contracts')}}</option>
				<option value="active">{{_('Active contracts')}}</option>
				<option value="active-upcoming">{{_('Active + upcoming contracts')}}</option>
			</ez-radio>
			
			<div style="display: flex; flex-direction: row;">
				<ez-date name="sd" 
							value="" 
							label="" 
							placeholder="{{_('Start date')}}"></ez-date>
				<ez-date name="ed" 
							value="" 
							label="" 
							placeholder="{{_('End date')}}"></ez-date>
			</div>
		</div>
		
		<hr/>
		
		<div id="container-contracts"></div>
		
	`;
	
	tplContracts = `
		<table class="table">
			<thead>
				<tr>
					<th style="width: 30px;">#</th>
					<th>{{_('Customer name')}}</th>
					<th>{{_('Description')}}</th>
					<th>{{_('Start')}}</th>
					<th>{{_('End')}}</th>
					<th>{{_('# Contracts')}}</th>
				</tr>
			</thead>
			<tbody ez-for="contracts" ez-item="c">
				<tr class="clickable" [onclick]="widget.gotoContract_Click" [contract]="c">
					<td>{{c.rentalContractId}}</td>
					<td>{{c.customerName}}</td>
					<td>{{c.description}}</td>
					<td>
						{{ c.startTime ? format_date(c.startTime, {dmy: true}) : '' }}
					</td>
					<td>
						{{ c.endTime ? format_date(c.endTime, {dmy: true}) : '' }}
					</td>
					<td>
						{{ c.lineCount }}
					</td>
				</tr>
				
			</tbody>
			<tr ez-if="contracts.length == 0" class="no-results-found">
				<td colspan="100%">
					{{_('No results found')}}
				</td>
			</tr>
		</table>
	
	`;
	
	
	container = null;
	
	ezTpl = null;

	
	init( e ) {
		this.container = e;
		
		this.render();
		
		this.search();
	}
	
	
	
	newContract_Click() {
		
		gotoRoute( '/sales/rental/new/' );
		
	}
	
	
	search() {
		
		postJson( '/service/sales/rental/rental.do', {
			a: 'searchContracts'
		}).then(async (e) => {
			let json = await e.json();
			
			let ezTpl = new EzTemplate('container-contracts');
			ezTpl.setObject('widget', this);
			
			ezTpl.setVar('contracts', json.contracts);
			ezTpl.loadHtml( this.tplContracts );
			
			console.log(json.contracts);
			
			
			ezTpl.render();
			
		}).catch((err) => {
			console.log('Error', err);
		});
		
		
		
	}
	
	
	gotoContract_Click( evt, tr )  {
		let c = tr.contract;
		
		gotoRoute( '/sales/rental/edit/?id=' + c.rentalContractId );
	}
	
	
	render() {
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
	}
	
}

